<?php
// Inclui o arquivo de conexão com o banco de dados
// NOTA: 'conexao.php' deve ter a conexão $conn com sismag na porta 3307.
include 'conexao.php'; 
session_start();

// ----------------------------------------------------
// 1. Buscar Usuários/Funcionários para Listar (Carregamento Dinâmico)
// ----------------------------------------------------
$funcionarios = [];
$erro_listagem = '';
$ano_lectivo_atual = date('Y'); // Pega o ano atual para passar nos links

// Usando as colunas id, nome, perfil e usuario da tabela 'usuarios'.
// NOTA: Para funcionar corretamente, a coluna 'agente' é usada em documento_oficial.php, 
// mas não está sendo selecionada aqui. Adicionei-a para o caso de ser necessária no futuro.
$sql = "SELECT id, nome, perfil, usuario, agente FROM usuarios ORDER BY nome";
$res = $conn->query($sql); 

if ($res) {
    while ($row = $res->fetch_assoc()) {
        $funcionarios[] = $row;
    }
} else {
    // Usamos $conn->error para pegar o erro específico do MySQLi
    $erro_listagem = "ERRO: Falha ao listar. Verifique a conexão com o BD (sismag). Detalhe: " . $conn->error;
}

?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Lista Dinâmica de Funcionários (Usuários)</title>
    <style>
        /* Estilos básicos */
        body { font-family: Arial, sans-serif; margin: 20px; }
        h1 { color: #004080; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 12px; text-align: left; }
        th { background-color: #004080; color: white; }
        tr:nth-child(even) { background-color: #f2f2f2; }
        td a { text-decoration: none; color: #004080; font-weight: bold; }
        td a.btn-avaliar { color: #28a745; } /* Verde para Avaliar */
        td a.btn-documento { color: #007bff; } /* Azul para Documento */
        td a:hover { text-decoration: underline; }
        .mensagem-erro { 
            color: #d8000c; 
            background-color: #ffbaba; 
            border: 1px solid #d8000c; 
            padding: 10px; 
            margin-bottom: 20px; 
        }
        .botoes-acoes {
            display: flex;
            gap: 10px; /* Espaçamento entre os links */
            white-space: nowrap;
        }
    </style>
</head>
<body>

    <h1>Lista Dinâmica de Funcionários (Usuários)</h1>

    <?php 
    if (isset($erro_listagem) && $erro_listagem): 
    ?>
        <p class="mensagem-erro">
            <?= htmlspecialchars($erro_listagem) ?><br>
            **Nota:** A lista será carregada dinamicamente assim que a conexão com o banco de dados for restabelecida.
        </p>
    <?php endif; ?>

    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Nome Completo</th>
                <th>Perfil / Cargo</th>
                <th>Usuário de Login</th>
                <th style="text-align: center; width: 25%;">Ações</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            foreach($funcionarios as $f): 
            ?>
            <tr>
                <td><?= htmlspecialchars($f['id']) ?></td>
                <td><?= htmlspecialchars($f['nome']) ?></td>
                <td><?= htmlspecialchars($f['perfil'] ?? '-') ?></td>
                <td><?= htmlspecialchars($f['usuario'] ?? '-') ?></td>
                <td style="text-align: center;">
                    <div class="botoes-acoes">
                        <a href="ficha_avaliacao_detalhada.php?id=<?= $f['id'] ?>&ano=<?= $ano_lectivo_atual ?>&trimestre=1" class="btn-avaliar">
                            📝 Avaliar
                        </a>

                        <a href="documento_oficial.php?id=<?= $f['id'] ?>&modo=anual" class="btn-documento">
                            📄 Ver Ficha (Anual)
                        </a>
                    </div>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <?php if (empty($funcionarios) && !isset($erro_listagem)): ?>
        <p style="margin-top: 20px; font-style: italic;">Nenhum usuário/funcionário encontrado na tabela "usuarios".</p>
    <?php endif; ?>

</body>
</html>